<?php
header("Content-Type: application/json");
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Step 1: OTP Verification
    if (!isset($data['otp'])) {
        echo json_encode(['status' => 'error', 'message' => 'OTP is required']);
        exit();
    }

    $otp = $conn->real_escape_string($data['otp']);
    $sql = "SELECT * FROM visitors_gate_pass WHERE otp_code = '$otp' AND status = 2";
    $result = $conn->query($sql);

    if ($result->num_rows === 0) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid OTP']);
        exit();
    }

    $visitor = $result->fetch_assoc();

    // Step 2: Validate Visitor Details
    $required_fields = ['email', 'phone', 'address'];
    foreach ($required_fields as $field) {
        if (!isset($data[$field])) {
            echo json_encode(['status' => 'error', 'message' => "$field is required"]);
            exit();
        }
    }

    $email = $conn->real_escape_string($data['email']);
    $phone = $conn->real_escape_string($data['phone']);
    $address = $conn->real_escape_string($data['address']);

    // Verify details match database records
    if ($email !== $visitor['visitors_email'] || 
        $phone !== $visitor['visitors_phone'] || 
        $address !== $visitor['visitors_address']) {
        echo json_encode(['status' => 'error', 'message' => 'Visitor details do not match']);
        exit();
    }

    // Step 3: Handle Photo Upload
    if (isset($_FILES['photo'])) {
        $target_dir = "images/visitors/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }

        $file_extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
        $filename = "visitor_" . $visitor['pass_id'] . "_" . time() . "." . $file_extension;
        $target_file = $target_dir . $filename;

        // Validate image
        $check = getimagesize($_FILES['photo']['tmp_name']);
        if ($check === false) {
            echo json_encode(['status' => 'error', 'message' => 'File is not an image']);
            exit();
        }

        // Check file size (max 2MB)
        if ($_FILES['photo']['size'] > 2000000) {
            echo json_encode(['status' => 'error', 'message' => 'Image is too large (max 2MB)']);
            exit();
        }

        // Allow certain file formats
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        if (!in_array(strtolower($file_extension), $allowed_extensions)) {
            echo json_encode(['status' => 'error', 'message' => 'Only JPG, JPEG, PNG & GIF files are allowed']);
            exit();
        }

        // Upload file
        if (move_uploaded_file($_FILES['photo']['tmp_name'], $target_file)) {
            // Update database with photo path
            $update_sql = "UPDATE visitors_gate_pass 
                          SET visitors_image = '$target_file', status = 3 
                          WHERE pass_id = " . $visitor['pass_id'];
            
            if ($conn->query($update_sql)) {
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Visitor verified and photo uploaded successfully',
                    'photo_path' => $target_file
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Database update failed: ' . $conn->error
                ]);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error uploading photo']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Photo is required']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}

$conn->close();
?>